' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Collections.Generic

''' <summary>
''' Klasa ShoppingCart reprezentuje koszyk, do ktrego uytkownicy mog dodawa produkty. Posida metody do dodawania, aktualizacji i usuwania pozycji oraz waciwoci, ktre zwracaj cakowit warto zamwienia i liczb zamwionych przedmiotw.
''' </summary>
<Serializable()> _
Public Class ShoppingCart

#Region "Zmienne prywatne"

  Private _items As List(Of OrderedProduct) = New List(Of OrderedProduct)

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Domylny konstruktor klasy ShoppingCart.
  ''' </summary>
  Public Sub New()
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca cakowit liczb pozycji w koszyku.
  ''' </summary>
  ''' <remarks>Zauwa e ta waciwo zwraca cakowit liczb zamwionych przedmiotw, a nie liczb unikalnych produktw w koszyku.</remarks>
  Public ReadOnly Property Count() As Integer
    Get
      Dim tempResult As Integer
      For Each myOrderedProduct As OrderedProduct In _items
        tempResult += myOrderedProduct.Quantity
      Next
      Return tempResult
    End Get
  End Property

  ''' <summary>
  ''' Zwraca list tylko do odczytu List (Of OrderedProduct)
  ''' </summary>
  Public ReadOnly Property Items() As List(Of OrderedProduct)
    Get
      Return _items
    End Get
  End Property

  ''' <summary>
  ''' Zwraca cakowit warto zamwienia.
  ''' </summary>
  Public ReadOnly Property Total() As Decimal
    Get
      Dim tempResult As Decimal
      For Each myOrderedProduct As OrderedProduct In _items
        tempResult += myOrderedProduct.SubTotal
      Next
      Return tempResult
    End Get
  End Property

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Dodaje nowy zamwiony produkt do koszyka.
  ''' </summary>
  ''' <param name="theProduct">Produkt, ktry ma by dodany. Produkt jest opakowywany wewntrz obiektu OrderedProduct dodawnaego do kolekcji _items.</param>
  Public Sub Add(ByVal theProduct As Product)
    For Each existingProduct As OrderedProduct In _items
      If theProduct.Id = existingProduct.ProductId Then
        existingProduct.Quantity += 1
        Exit Sub
      End If
    Next
    Dim myOrderedProduct As OrderedProduct = New OrderedProduct(theProduct, 1)
    _items.Add(myOrderedProduct)
  End Sub

  ''' <summary>
  ''' Aktualizuje ilo istniejcego produktu.
  ''' </summary>
  ''' <param name="newQuantity">Nowa ilo zamawianego produktu.</param>
  ''' <param name="id">Identyfikator obiektu OrderedProduct w koszyku.</param>
  Public Sub Update(ByVal newQuantity As Integer, ByVal id As Guid)
    For Each myOrderedProduct As OrderedProduct In _items
      If myOrderedProduct.Id = id Then
        myOrderedProduct.Quantity = newQuantity
      End If
    Next
  End Sub

  ''' <summary>
  ''' Usuwa pozycj z koszyka.
  ''' </summary>
  ''' <param name="id">Unikalny identyfikator zamawianego produktu, ktry ma by usunity.</param>
  Public Sub Remove(ByVal id As Guid)
    For Each myOrderedProduct As OrderedProduct In _items
      If id = myOrderedProduct.Id Then
        _items.Remove(myOrderedProduct)
        Exit For
      End If
    Next
  End Sub

  ''' <summary>
  ''' Czyci cay koszyk.
  ''' </summary>
  Public Sub Clear()
    _items.Clear()
  End Sub

#End Region

End Class
